/****************************************************************************************/
/**
  Copyright (c) 2008 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file       Pwm_ReportError.c
  \brief      Catch any inconsistencies with Pwm Function Parameters
  \author     Freescale Semiconductor
  \author     R01160
  \author     Guadalajara Applications Laboratory RTAC Americas
  \version    0.1
  \date       4/14/2008 11:43:36 AM
  \warning    Do not modify Error type definitions in Pwm_ReportError.h file

  * History:
  
*/
/****************************************************************************************/

/** Pwm Error definitions */
#include "Pwm_ReportError.h"
/** Report Error Type Variables. Store last Error type Event */
uint8_t Pwm_ApiId      = 0;
uint8_t Pwm_ErrorId    = 0;


/**
 * \brief     Serve to catch and save any data inconsistency passed throughout \n
 *            every Pwm function. Each type of error is saved in RAM variables \n
 *            user is able to use them as convenience.
 * \author    R01160
 * \param     Pwm Instance Id, Api Error type, Error definition tyoe
 * \return    none
 * \todo
 * \warning
 */  
 void vfnPwm_Report_Error(uint8_t ApiId, uint8_t ErrorId)
 {
   
   Pwm_ApiId      = ApiId;       /* Store last Api Id where Error Comes */
   Pwm_ErrorId    = ErrorId;     /* Store last type of Error Reported   */

 } 
